/*

    Zelda Return of the Hylian

    Copyright (C) 2005-2008  Vincent Jouillat

    Please send bugreports with examples or suggestions to www.zeldaroth.fr

*/

#include <sstream>
#include <fstream>
#include <iostream>

#include <SDL.h>

#include "Audio.h"

Audio::Audio() : musiqueId(0), specialId(0) {
    SOUND = true;
    music = NULL;
    
    if(SDL_InitSubSystem(SDL_INIT_AUDIO) == -1) SOUND = false;
    
    if (SOUND) {
        Mix_OpenAudio(44100, AUDIO_S16SYS, 2, 2048);
        previous_volume = Mix_VolumeMusic(32);
        loadSounds();
        setVolson(32);
    }
}

Audio::~Audio() {
    if (SOUND) {
        freeSounds();
        Mix_PauseMusic();
        Mix_VolumeMusic(previous_volume);
        Mix_HaltMusic();
        Mix_FreeMusic(music);
        Mix_CloseAudio();
    }
}

void Audio::setVolume(int volume) {
	Mix_VolumeMusic(volume);
}

void Audio::setVolson(int volson) {
    for (int i = 0; i < 40; i++)
		Mix_VolumeChunk(sons[i], volson);
}

void Audio::loadSounds() {
    sons = new Mix_Chunk*[40];

	sons[0] = Mix_LoadWAV("D:\\data\\sound\\text.ogg"); // lettres
    sons[1] = Mix_LoadWAV("D:\\data\\sound\\menu1.ogg"); // menu 1
    sons[2] = Mix_LoadWAV("D:\\data\\sound\\menu2.ogg"); // menu 2
    sons[3] = Mix_LoadWAV("D:\\data\\sound\\menu3.ogg"); // menu 3
    sons[4] = Mix_LoadWAV("D:\\data\\sound\\menu4.ogg"); // menu 4
    sons[5] = Mix_LoadWAV("D:\\data\\sound\\timewarp.ogg"); // time retour
    sons[6] = Mix_LoadWAV("D:\\data\\sound\\tombe.ogg"); // tombe (ennemi)
    sons[7] = Mix_LoadWAV("D:\\data\\sound\\hitenemy.ogg"); //shot 1
    sons[8] = Mix_LoadWAV("D:\\data\\sound\\killenemy.ogg"); // shot 2
    sons[9] = Mix_LoadWAV("D:\\data\\sound\\surprise.ogg"); // surprise
    sons[10] = Mix_LoadWAV("D:\\data\\sound\\monte.ogg"); // monte
    sons[11] = Mix_LoadWAV("D:\\data\\sound\\descend.ogg"); // descend
    sons[12] = Mix_LoadWAV("D:\\data\\sound\\chute.ogg"); // chute
    sons[13] = Mix_LoadWAV("D:\\data\\sound\\item.ogg"); // item
    sons[14] = Mix_LoadWAV("D:\\data\\sound\\rupee.ogg"); // rubis
    sons[15] = Mix_LoadWAV("D:\\data\\sound\\heart.ogg"); // coeur
    sons[16] = Mix_LoadWAV("D:\\data\\sound\\bomb.ogg"); // bombe
    sons[17] = Mix_LoadWAV("D:\\data\\sound\\textnext.ogg"); // suite texte
    sons[18] = Mix_LoadWAV("D:\\data\\sound\\textend.ogg"); // fin texte
    sons[19] = Mix_LoadWAV("D:\\data\\sound\\happy.ogg"); // trouve objet
    sons[20] = Mix_LoadWAV("D:\\data\\sound\\door.ogg"); // ouvre porte
    sons[21] = Mix_LoadWAV("D:\\data\\sound\\pics.ogg"); // pics contre mur
    sons[22] = Mix_LoadWAV("D:\\data\\sound\\sword.ogg"); // Epe
    sons[23] = Mix_LoadWAV("D:\\data\\sound\\SwordCharging.ogg"); // charge
    sons[24] = Mix_LoadWAV("D:\\data\\sound\\Sword360.ogg"); // spin
    sons[25] = Mix_LoadWAV("D:\\data\\sound\\shoot.ogg"); // flche
    sons[26] = Mix_LoadWAV("D:\\data\\sound\\hookshot.ogg"); // grappin
    sons[27] = Mix_LoadWAV("D:\\data\\sound\\stamp.ogg"); // pose bombe
    sons[28] = Mix_LoadWAV("D:\\data\\sound\\magic.ogg"); // magie
    sons[29] = Mix_LoadWAV("D:\\data\\sound\\burn.ogg"); // br˚le
    sons[30] = Mix_LoadWAV("D:\\data\\sound\\hammer.ogg"); // marteau
    sons[31] = Mix_LoadWAV("D:\\data\\sound\\plouf.ogg"); // plouf
    sons[32] = Mix_LoadWAV("D:\\data\\sound\\danger.ogg"); // danger
    sons[33] = Mix_LoadWAV("D:\\data\\sound\\hurt.ogg"); // link se blesse
    sons[34] = Mix_LoadWAV("D:\\data\\sound\\porte.ogg"); // porte objet
    sons[35] = Mix_LoadWAV("D:\\data\\sound\\lance.ogg"); // lance objet
    sons[36] = Mix_LoadWAV("D:\\data\\sound\\casse.ogg"); // casse objet
    sons[37] = Mix_LoadWAV("D:\\data\\sound\\charge.ogg"); // charge magie
    sons[38] = Mix_LoadWAV("D:\\data\\sound\\buisson.ogg"); // coupe buisson
    sons[39] = Mix_LoadWAV("D:\\data\\sound\\pousse.ogg"); // pousse caisse
}

void Audio::freeSounds() {
    if (SOUND) {
        for (int i = 0; i < 40; i++) Mix_FreeChunk(sons[i]);
        delete[] sons;
    }
}

void Audio::playSound(int id, int chl) {
    if (SOUND) Mix_PlayChannel(chl,sons[id],0);
}

void Audio::playMusic(int id) {
    if (SOUND) {
        if (musiqueId != id) {
	    musiqueId = id;            
            if (specialId == 0) {
		Mix_HaltMusic();
		Mix_FreeMusic(music);
		music = choixMusique(id);
		Mix_PlayMusic(music,-1);
		specialId = 0;
	    }
        }
    }
}

void Audio::stopMusic() {
    if (SOUND) Mix_HaltMusic();
}

void Audio::replayMusic() {
    if (SOUND) Mix_PlayMusic(music,-1);
}

Mix_Music* Audio::choixMusique(int id) {
    switch (id) {
        case 1 : return Mix_LoadMUS("D:\\data\\music\\Foret.ogg");
        case 2 : return Mix_LoadMUS("D:\\data\\music\\Plaine.ogg");
        case 3 : return Mix_LoadMUS("D:\\data\\music\\Lac.ogg");
        case 4 : return Mix_LoadMUS("D:\\data\\music\\Mont.ogg");
        case 5 : return Mix_LoadMUS("D:\\data\\music\\Desert.ogg");
        case 6 : return Mix_LoadMUS("D:\\data\\music\\Ombre.ogg");
        case 7 : return Mix_LoadMUS("D:\\data\\music\\Feu.ogg");
        case 8 : return Mix_LoadMUS("D:\\data\\music\\Cocorico.ogg");
        case 9 : return Mix_LoadMUS("D:\\data\\music\\Chateau.ogg");
        case 10 : case 11 : return Mix_LoadMUS("D:\\data\\music\\Secret.ogg");
        case 12 : case 13 : case 14 : return Mix_LoadMUS("D:\\data\\music\\Donjon1.ogg");
        case 15 : return Mix_LoadMUS("D:\\data\\music\\DDesert.ogg");
        case 16 : case 17 : case 18 : return Mix_LoadMUS("D:\\data\\music\\Donjon2.ogg");
        case 19 : return Mix_LoadMUS("D:\\data\\music\\DSecret.ogg");
        case 20 : return Mix_LoadMUS("D:\\data\\music\\DFinal.ogg");
        case 21 : return Mix_LoadMUS("D:\\data\\music\\Home.ogg");
        case 22 : case 23 : return Mix_LoadMUS("D:\\data\\music\\Cave.ogg");
        case 24 : case 25 : case 26 : case 27 : return Mix_LoadMUS("D:\\data\\music\\Fee.ogg"); break;
//case 28 : case 32 : case 35 : case 36 : case 38 : case 41 : case 42 : case 43 : case 44 :
//    return Mix_LoadMUS("D:\\data\\music\\Maison.ogg"); break;
        case 29 : case 37 : case 40 : return Mix_LoadMUS("D:\\data\\music\\Potion.ogg"); break;
        case 30 : return Mix_LoadMUS("D:\\data\\music\\Bar.ogg"); break;
        case 31 : return Mix_LoadMUS("D:\\data\\music\\Magasin.ogg"); break;
        case 33 : case 34 : case 39 : return Mix_LoadMUS("D:\\data\\music\\Jeu.ogg"); break;
        case 45 : return Mix_LoadMUS("D:\\data\\music\\Titre.ogg"); break;
        case 46 : return Mix_LoadMUS("D:\\data\\music\\Selection.ogg"); break;
        case 47 : return Mix_LoadMUS("D:\\data\\music\\Debut.ogg"); break;
        default : return Mix_LoadMUS("D:\\data\\music\\Maison.ogg");
    }
}

void Audio::playSpecial(int id) {
    if (SOUND) {
        if (specialId != id) {
            Mix_HaltMusic();
            Mix_FreeMusic(music);
            music = choixSpecial(id);
            Mix_PlayMusic(music,-1);
            specialId=id;
        }    
    }
}

void Audio::stopSpecial() {
    if (!specialId) return;
    int tmp = musiqueId;
    musiqueId = 0;
    specialId = 0;
    playMusic(tmp);
}

Mix_Music* Audio::choixSpecial(int id) {
    switch (id) {
        case 1 : return Mix_LoadMUS("D:\\data\\music\\Boss.ogg");
        case 2 : return Mix_LoadMUS("D:\\data\\music\\Mort.ogg");
        case 3 : return Mix_LoadMUS("D:\\data\\music\\Epee.ogg");
        case 4 : return Mix_LoadMUS("D:\\data\\music\\BossF.ogg");
        case 5 : return Mix_LoadMUS("D:\\data\\music\\Fin.ogg");
        default : return Mix_LoadMUS("D:\\data\\music\\Boss.ogg");
    }
}

